#!/bin/env ruby
# encoding: utf-8
require 'rubygems'
require 'rspec'
require 'watir-webdriver'
require 'page-object'
require 'oci8'

require_relative '../../module/DriverUtility'
require_relative '../rspec_helper'
require_relative '../../pages/landing'
require_relative '../../pages/login'
require_relative '../../pages/eula'
require_relative '../../common/common'
require_relative '../../pages/landing_appointments'
require_relative '../../pages/appointments/new_appointment_request'
require_relative '../../pages/appointments/booked_appointment_detail'
require_relative '../../helper/modal'
require_relative '../../module/database/OracleUtility'
require_relative '../../module/DateUtility'
require_relative '../../helper/error_validation'
require_relative '../../module/database/MongoUtility'
require_relative '../../pages/feedback'
require_relative '../../pages/landing_notifications'

describe '[Story# VAR-7864: New Appointment/Request Form: Routing question - Step 2: Location]
          [Story# VAR-7912: New Appointment/Request Form: Routing question - Step 3: Method]'  do

  include DriverUtility
  include OracleUtility
  include DateUtility
  include MongoUtility


  before(:all) do
    initializeConfigurations(VAR_BASE_URL)
    @landing_appointments = LandingAppointments.new(@driver)
    @login = Login.new(@driver)
    @eula = Eula.new(@driver)
    @common = Common.new(@driver)
    @modal = Modal.new(@driver)
    @new_appointment = NewAppointmentRequest.new(@driver)
    @detail = BookedAppointmentDetail.new(@driver)
    @error = Error_Validation.new(@driver)
    @feedback = Feedback.new(@driver)
    @landing_notifications = LandingNotifications.new(@driver)
    @modal = Modal.new(@driver)
    TITLE = "Appointments/Requests"
    @@patientID ="1113138327"
    @db = connectToMongoDB("var-utility")
    restoreCollection("siteSupportingVAR", "var-utility", "sites-supporting-var-exported2.json", @db)
    restoreCollection("clinical-services", "var-utility", "clinical_services_default.json", @db)
    restoreCollection("directBookingEligibilityCriteria", "var-utility", "directSchedulingEnabled.json", @db)
    restoreCollection("requestEligibilityCriteria", "var-utility", "requestEligibilityCriteria.json", @db)
    restoreCollection("custom-friendly-text", "var-utility", "facility_friendly_name.json", @db)
    deletePatientData(@@patientID)
    @common.loginEndsOnHome(pw_redacted)
    @landing_appointments.appointment_header_element.wait_until_present(TIME_OUT_LIMIT)

  end

  after(:all) do
    @driver.close
  end

  context 'AC#VAR-9749|TC#VAR-9750: New Appointment/Request Form: Routing question - Step 2: Location' do

    it 'should show no locations and instructional text' do
      @common.selectAddAppointmentButton("VA")
      @new_appointment.selectTypeOfCare(AUDIOLOGY)
      @new_appointment.selectState("636A6")
      expect(@new_appointment.location_instruction_element.text).to eq "Unfortunately, there are no locations where you are registered that are offering #{AUDIOLOGY} through this app.\nIf you cannot find the location you need, please visit the VA Facility Locator to contact the facility for assistance."
    end

  end

    context 'AC#VAR-9960|TC#VAR-9961: New Appointment/Request Form: Routing question - Step 3: Method' do

      it 'should show that method Submit a Request to VA Scheduler is not available for Veteran that has not visited the site in past 12 months' do
        @new_appointment.selectTypeOfCare(MENTAL_HEALTH)
        @new_appointment.selectState("523")
        @new_appointment.selectLocation("523GC")
        @new_appointment.patient_history_limit_clerk_element.wait_until_present(TIME_OUT_LIMIT)
        expect(@new_appointment.patient_history_limit_clerk_element.text).to eq "This method is not available because you have not received this type of care in the last 12 months. Please select another method, if available, or contact your facility for assistance."
      end

      it 'should show that Schedule Myself is not available for Veteran that has not visited the site in past 24 months' do
        expect(@new_appointment.patient_history_limit_myself_element.text).to eq "This method is not available because you have not received this type of care in the last 24 months. Please select another method, if available, or contact your facility for assistance."
      end

    end

  end